/*
 * Decompiled with CFR 0.152.
 */
package me.hytaleserverlist.mods.query;

import com.hypixel.hytale.logger.HytaleLogger;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import me.hytaleserverlist.mods.query.QueryProtocol;

public class QueryHandler
extends ChannelInboundHandlerAdapter {
    @Nonnull
    private final HytaleLogger logger;

    public QueryHandler(@Nonnull HytaleLogger logger) {
        this.logger = logger;
    }

    public boolean isSharable() {
        return true;
    }

    public void channelRead(@Nonnull ChannelHandlerContext ctx, @Nonnull Object msg) throws Exception {
        DatagramPacket packet;
        ByteBuf content;
        if (msg instanceof DatagramPacket && QueryProtocol.isQueryRequest(content = (ByteBuf)(packet = (DatagramPacket)msg).content())) {
            this.handleQuery(ctx, packet);
            return;
        }
        ctx.fireChannelRead(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleQuery(@Nonnull ChannelHandlerContext ctx, @Nonnull DatagramPacket request) {
        try {
            byte queryType = QueryProtocol.getQueryType((ByteBuf)request.content());
            this.logger.at(Level.FINE).log("Query request (type=%d) from %s", queryType, (Object)request.sender());
            ByteBuf response = queryType == 1 ? QueryProtocol.buildFullResponse(ctx.alloc()) : QueryProtocol.buildBasicResponse(ctx.alloc());
            ctx.writeAndFlush((Object)new DatagramPacket(response, (InetSocketAddress)request.sender()));
        }
        catch (Exception e) {
            ((HytaleLogger.Api)this.logger.at(Level.WARNING).withCause((Throwable)e)).log("Failed to process query from %s", (Object)request.sender());
        }
        finally {
            request.release();
        }
    }

    public void exceptionCaught(@Nonnull ChannelHandlerContext ctx, @Nonnull Throwable cause) {
        ((HytaleLogger.Api)this.logger.at(Level.WARNING).withCause(cause)).log("Exception in query handler");
        ctx.fireExceptionCaught(cause);
    }
}

