/*
 * Decompiled with CFR 0.152.
 */
package me.hytaleserverlist.mods.query;

import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.server.core.io.ServerManager;
import com.hypixel.hytale.server.core.plugin.JavaPlugin;
import com.hypixel.hytale.server.core.plugin.JavaPluginInit;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import me.hytaleserverlist.mods.query.QueryHandler;

public class QueryPlugin
extends JavaPlugin {
    private static final String HANDLER_NAME = "hytale-query";
    private QueryHandler queryHandler;

    public QueryPlugin(@Nonnull JavaPluginInit init) {
        super(init);
    }

    protected void start() {
        ServerManager.get().waitForBindComplete();
        this.queryHandler = new QueryHandler(this.getLogger());
        int registered = 0;
        for (Channel channel : ServerManager.get().getListeners()) {
            try {
                ChannelPipeline pipeline = channel.pipeline();
                pipeline.addFirst(HANDLER_NAME, (ChannelHandler)this.queryHandler);
                ++registered;
                this.getLogger().at(Level.FINE).log("Registered query handler on %s", (Object)channel.localAddress());
            }
            catch (Exception e) {
                ((HytaleLogger.Api)this.getLogger().at(Level.WARNING).withCause((Throwable)e)).log("Failed to register query handler on %s", (Object)channel.localAddress());
            }
        }
        this.getLogger().at(Level.INFO).log("Query protocol enabled on %d listener(s)", registered);
    }

    protected void shutdown() {
        if (this.queryHandler == null) {
            return;
        }
        int removed = 0;
        for (Channel channel : ServerManager.get().getListeners()) {
            try {
                ChannelPipeline pipeline = channel.pipeline();
                if (pipeline.get(HANDLER_NAME) == null) continue;
                pipeline.remove(HANDLER_NAME);
                ++removed;
            }
            catch (Exception e) {
                this.getLogger().at(Level.FINE).log("Handler already removed from %s", (Object)channel.localAddress());
            }
        }
        this.getLogger().at(Level.INFO).log("Query protocol disabled, removed from %d listener(s)", removed);
        this.queryHandler = null;
    }
}

