/*
 * Decompiled with CFR 0.152.
 */
package me.hytaleserverlist.mods.query;

import com.hypixel.hytale.common.plugin.PluginIdentifier;
import com.hypixel.hytale.common.util.java.ManifestUtil;
import com.hypixel.hytale.server.core.HytaleServer;
import com.hypixel.hytale.server.core.io.ServerManager;
import com.hypixel.hytale.server.core.plugin.PluginBase;
import com.hypixel.hytale.server.core.plugin.PluginManager;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.Universe;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;

public final class QueryProtocol {
    public static final byte[] REQUEST_MAGIC = "HYQUERY\u0000".getBytes(StandardCharsets.US_ASCII);
    public static final byte[] RESPONSE_MAGIC = "HYREPLY\u0000".getBytes(StandardCharsets.US_ASCII);
    public static final byte TYPE_BASIC = 0;
    public static final byte TYPE_FULL = 1;
    public static final int MIN_REQUEST_SIZE = REQUEST_MAGIC.length + 1;

    private QueryProtocol() {
    }

    public static boolean isQueryRequest(@Nonnull ByteBuf buf) {
        if (buf.readableBytes() < MIN_REQUEST_SIZE) {
            return false;
        }
        for (int i = 0; i < REQUEST_MAGIC.length; ++i) {
            if (buf.getByte(i) == REQUEST_MAGIC[i]) continue;
            return false;
        }
        return true;
    }

    public static byte getQueryType(@Nonnull ByteBuf buf) {
        return buf.getByte(REQUEST_MAGIC.length);
    }

    @Nonnull
    public static ByteBuf buildBasicResponse(@Nonnull ByteBufAllocator alloc) {
        ByteBuf buf = alloc.buffer();
        buf.writeBytes(RESPONSE_MAGIC);
        buf.writeByte(0);
        QueryProtocol.writeString(buf, HytaleServer.get().getConfig().getServerName());
        QueryProtocol.writeString(buf, HytaleServer.get().getConfig().getMotd());
        buf.writeIntLE(Universe.get().getPlayerCount());
        buf.writeIntLE(Math.max(HytaleServer.get().getConfig().getMaxPlayers(), 0));
        buf.writeShortLE(QueryProtocol.getHostPort());
        QueryProtocol.writeString(buf, QueryProtocol.getVersion());
        buf.writeIntLE(1);
        QueryProtocol.writeString(buf, "6708f121966c1c443f4b0eb525b2f81d0a8dc61f5003a692a8fa157e5e02cea9");
        return buf;
    }

    @Nonnull
    public static ByteBuf buildFullResponse(@Nonnull ByteBufAllocator alloc) {
        ByteBuf buf = alloc.buffer();
        buf.writeBytes(RESPONSE_MAGIC);
        buf.writeByte(1);
        QueryProtocol.writeString(buf, HytaleServer.get().getConfig().getServerName());
        QueryProtocol.writeString(buf, HytaleServer.get().getConfig().getMotd());
        List players = Universe.get().getPlayers();
        buf.writeIntLE(players.size());
        buf.writeIntLE(Math.max(HytaleServer.get().getConfig().getMaxPlayers(), 0));
        buf.writeShortLE(QueryProtocol.getHostPort());
        QueryProtocol.writeString(buf, QueryProtocol.getVersion());
        buf.writeIntLE(1);
        QueryProtocol.writeString(buf, "6708f121966c1c443f4b0eb525b2f81d0a8dc61f5003a692a8fa157e5e02cea9");
        buf.writeIntLE(players.size());
        for (PlayerRef player : players) {
            QueryProtocol.writeString(buf, player.getUsername());
            QueryProtocol.writeUUID(buf, player.getUuid());
        }
        List plugins = PluginManager.get().getPlugins();
        buf.writeIntLE(plugins.size());
        for (PluginBase plugin : plugins) {
            PluginIdentifier id = plugin.getIdentifier();
            QueryProtocol.writeString(buf, id.toString());
            QueryProtocol.writeString(buf, plugin.getManifest().getVersion().toString());
            buf.writeBoolean(plugin.isEnabled());
        }
        return buf;
    }

    private static String getVersion() {
        String version = ManifestUtil.getImplementationVersion();
        return version != null ? version : "unknown";
    }

    private static void writeString(@Nonnull ByteBuf buf, @Nonnull String str) {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        buf.writeShortLE(bytes.length);
        buf.writeBytes(bytes);
    }

    private static void writeUUID(@Nonnull ByteBuf buf, @Nonnull UUID uuid) {
        buf.writeLong(uuid.getMostSignificantBits());
        buf.writeLong(uuid.getLeastSignificantBits());
    }

    private static int getHostPort() {
        try {
            InetSocketAddress address = ServerManager.get().getNonLoopbackAddress();
            if (address != null) {
                return address.getPort();
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return 5520;
    }
}

